#!/usr/bin/perl -w

##pipeline的第二步

use strict;
use Getopt::Long;
use Pod::Usage;
use POSIX;
use Math::CDF;

my $man = '';
my $help= '';

my $input_file='';

my $version = '';
my $acc1=shift;
my $acc2=shift;
my $acc3=shift;


GetOptions('help|?' => \$help,
	   man => \$man,
	   'input=s'=>\$input_file,
	   'version'=>\$version
    )
    or pod2usage(2);
pod2usage(1) if $help;
pod2usage(-verbose => 2) if $man;

### step 2  ####################################################################################

my $i=0;

my %codon=&codon_table();
my %hash;

open (FILE,$input_file) or die "wrong";
while (<FILE>){
    next if $_=~/>/;
    $i++;
    chomp;
    $hash{$i}=$_;
}
close FILE; #将序列存储在hash里面。

my $acc_tmp1=$acc1+1;
my $acc_tmp2=$acc1+$acc2+2;
my $acc_tmp3=$acc1+$acc2+$acc3+3;

if (not exists $hash{$acc_tmp1} or  not exists $hash{$acc_tmp2} or  not exists $hash{$acc_tmp3}){
    print "$input_file does not have enough data. \n";
    exit;
}

if ($hash{$acc_tmp1} eq $hash{$acc_tmp2} and $hash{$acc_tmp1} eq $hash{$acc_tmp3}){ #3条参考序列完全一致
    my $length=length($hash{$acc_tmp1}); #参考序列长度 也即是分析的基因的CDS长度
    for (my $short=1;$short<$acc_tmp3;$short++){
	$length=length($hash{$short}) if $length>length($hash{$short});
    }
    $length=int($length/3)*3; ##确保length是3的倍数
    my @final_snp1_flag;
    my @final_snp2_flag;
    my @final_snp3_flag;

    my $repl_fix=0;
    my $repl_poly=0;
    my $sys_fix=0;
    my $sys_poly=0;

    for (my $n=0;$n<$length;$n=$n+3){ #以codon为单位，逐步读取CDS序列
        $final_snp1_flag[$n]="poly";
###  先假定所有位点的状态为fix，显然，此处有问题。因为所有的全部相同的位点，已经在后续中被跳过，也就是非SNP/polymophison 位点。
###  这里的真实定义应该是三个物种中，有两个物种的SNP一致，另外一个物种的SNP与前两者不同，但物种内也一致。
###  e.g.  AAAAAAAAAAAA（1） AAAAAAAAAAAAAA（2） TTTTTTTTTTTTT（3）; 此表明物种12的祖先与3分化的时候，产生了一个fix的T=>A的突变
###   or   AAAAAAAAAAAA（1） TTTTTTTTTTTTTT（2） TTTTTTTTTTTTT（3）; 此表明物种1的祖先从23祖先分化的时候，产生了一个fix的T=>A的突变
###   or   AAAAAAAAAAAA（1） TTTTTTTTTTTTTT（2） AAAAAAAAAAAAA（3）; 此表明物种2的祖先从13祖先分化的时候，产生了一个fix的T=>A的突变
        $final_snp2_flag[$n]="poly";
        $final_snp3_flag[$n]="poly";

        my $all_the_same1="T";  #这里是判断是否所有碱基都一致，都一致的话，不是我们需要分析的位点
        my $all_the_same2="T";
        my $all_the_same3="T";

        my $ref1=substr($hash{$acc_tmp1},$n,1);  #这里保存的是这一个密码子的每一个碱基 是参考序列的
        my $ref2=substr($hash{$acc_tmp1},$n+1,1);
        my $ref3=substr($hash{$acc_tmp1},$n+2,1);
        my $ref_codon=substr($hash{$acc_tmp1},$n,3); #这里保存的是整一个密码子
        my %jap_snp1;  #这里是定义了三个碱基的hash
        my %barth_snp1;
        my %rufi_snp1;

        my %jap_snp2;
        my %barth_snp2;
        my %rufi_snp2;

        my %jap_snp3;
        my %barth_snp3;
        my %rufi_snp3;

	my @japtmp1;
	my @japtmp2;
	my @japtmp3;
	my @japtmp_codon;

        for (my $jap=1;$jap<=$acc1;$jap++){  #对该物种的几个个体的这一codon内的碱基进行读取和保存
            $japtmp1[$jap]=substr($hash{$jap},$n,1);
            $japtmp2[$jap]=substr($hash{$jap},$n+1,1);
            $japtmp3[$jap]=substr($hash{$jap},$n+2,1);
            $japtmp_codon[$jap]=substr($hash{$jap},$n,3);
            $jap_snp1{$japtmp1[$jap]}++; ###对某一个位置的碱基进行区分，看是否存在多个碱基
            $jap_snp2{$japtmp2[$jap]}++;
            $jap_snp3{$japtmp3[$jap]}++;
        }

        my $barth_cnt=0;
	my @barthtmp1;
	my @barthtmp2;
	my @barthtmp3;
	my @barthtmp_codon;

        for (my $barth=$acc_tmp1+1;$barth<=$acc_tmp2-1;$barth++){  ##第二个物种
            $barth_cnt++;
            $barthtmp1[$barth_cnt]=substr($hash{$barth},$n,1);
            $barthtmp2[$barth_cnt]=substr($hash{$barth},$n+1,1);
            $barthtmp3[$barth_cnt]=substr($hash{$barth},$n+2,1);
            $barthtmp_codon[$barth_cnt]=substr($hash{$barth},$n,3);
            $barth_snp1{$barthtmp1[$barth_cnt]}++;
            $barth_snp2{$barthtmp2[$barth_cnt]}++;
            $barth_snp3{$barthtmp3[$barth_cnt]}++;
	}

	my $rufi_cnt=0;
	my @rufitmp1;
	my @rufitmp2;
	my @rufitmp3;
	my @rufitmp_codon;

        for (my $rufi=$acc_tmp2+1;$rufi<=$acc_tmp3-1;$rufi++){ ## 第三个物种
            $rufi_cnt++;
            $rufitmp1[$rufi_cnt]=substr($hash{$rufi},$n,1);
            $rufitmp2[$rufi_cnt]=substr($hash{$rufi},$n+1,1);
            $rufitmp3[$rufi_cnt]=substr($hash{$rufi},$n+2,1);
            $rufitmp_codon[$rufi_cnt]=substr($hash{$rufi},$n,3);
            $rufi_snp1{$rufitmp1[$rufi_cnt]}++;
            $rufi_snp2{$rufitmp2[$rufi_cnt]}++;
            $rufi_snp3{$rufitmp3[$rufi_cnt]}++;
	}
        my $japflag="sys";   ##假定本次读取的codon的变化都属于同义变化
        my $barthflag="sys";
        my $rufiflag="sys";
	
#	print "AAAAAAAAAAAAAAAAAAAA\n";
# 	exit if $n == 681;

        for (my $m=1;$m<=$acc1;$m++){   ##对三个物种的每一个个体进行分析
            if ($japtmp_codon[$m] =~/X|N|I|\s/){
                $japflag="none";
                $final_snp1_flag[$n]="none";
                $final_snp2_flag[$n]="none";
                $final_snp3_flag[$n]="none";
                last;
            }elsif($japtmp_codon[$m] =~/M|W|Y|K|S|R|H|V|D|B/){
		my %tmp_codon=&expand_codon($japtmp_codon[$m],$japtmp1[$m],$japtmp2[$m],$japtmp3[$m]);
		foreach my $tmp_key (sort keys %tmp_codon){
		    foreach my $tmp_key1 (sort keys %{$tmp_codon{$tmp_key}}){
			if ($codon{$tmp_codon{$tmp_key}{$tmp_key1}} ne $codon{$ref_codon}){
			    $japflag="repl";
			}
		    }   
		}
	    }else{
		if ($japtmp_codon[$m]=~/[^ATCG]/ or $ref_codon=~/[^ATCG]/){
#		    print "$input_file WWW \n =$ref_codon= =$japtmp_codon[$m]= !~/ATCG/\n";
		    last;
		}
                if ($codon{$ref_codon} ne $codon{$japtmp_codon[$m]}){
                    $japflag="repl";
                }else{
                }
            }

            if ($barthtmp_codon[$m] =~/X|N|I|\s/){
                $barthflag="none";
                $final_snp1_flag[$n]="none";
                $final_snp2_flag[$n]="none";
                $final_snp3_flag[$n]="none";
                last;
            }elsif($barthtmp_codon[$m] =~/M|W|Y|K|S|R|H|V|D|B/){
		my %tmp_codon=&expand_codon($barthtmp_codon[$m],$barthtmp1[$m],$barthtmp2[$m],$barthtmp3[$m]);
		foreach my $tmp_key (sort keys %tmp_codon){
		    foreach my $tmp_key1 (sort keys %{$tmp_codon{$tmp_key}}){
			if ($codon{$tmp_codon{$tmp_key}{$tmp_key1}} ne $codon{$ref_codon}){
			    $barthflag="repl";
			}
		    }   
		}
	    }else{
		if ($barthtmp_codon[$m]=~/[^ATCG]/ or $ref_codon=~/[^ATCG]/){
		    last;
		}
 
                if ($codon{$ref_codon} ne $codon{$barthtmp_codon[$m]}){
                    $barthflag="repl";
                }else{
                }
            }
            if ($rufitmp_codon[$m] =~/X|N|I|\s/){
                $rufiflag="none";
                $final_snp1_flag[$n]="none";
                $final_snp2_flag[$n]="none";
                $final_snp3_flag[$n]="none";
                last;
            }elsif($rufitmp_codon[$m] =~/M|W|Y|K|S|R|H|V|D|B/){
		my %tmp_codon=&expand_codon($rufitmp_codon[$m],$rufitmp1[$m],$rufitmp2[$m],$rufitmp3[$m]);
		foreach my $tmp_key (sort keys %tmp_codon){
		    foreach my $tmp_key1 (sort keys %{$tmp_codon{$tmp_key}}){
			if ($codon{$tmp_codon{$tmp_key}{$tmp_key1}} ne $codon{$ref_codon}){
			    $rufiflag="repl";
			}
		    }   
		}
	    }else{
		if ($rufitmp_codon[$m]=~/[^ATCG]/ or $ref_codon=~/[^ATCG]/){
		    last;
		}

                if ($codon{$ref_codon} ne $codon{$rufitmp_codon[$m]}){
                    $rufiflag="repl";
                }else{
                }
            }
        }
	my $final_sys_repl_none;
        if ($japflag eq "none" or $rufiflag eq "none" or $barthflag eq "none"){  ###只要有一个物种的codon为none，则最终为none
            $final_sys_repl_none ="none";
        }elsif ($japflag eq "repl" or $rufiflag eq "repl" or $barthflag eq "repl"){  ###只要有一个突变为repl，则所有为repl
            $final_sys_repl_none ="repl";
        }elsif ($japflag eq "sys" and $rufiflag eq "sys" and $barthflag eq "sys"){ ###如果全部为sys,则为sys
            $final_sys_repl_none ="sys";
        }else{  ###如果还有例外的情况，则输出情况，并终止程序！
            print "$japflag\t$rufiflag\t$barthflag\n Must Something Is Wrong!!\n";
            exit;
        }

        for (my $k=1;$k<=$acc1;$k++){  ###只要有一个碱基与参考序列不同，则把all_the_same设置成F，如果all_the_same是T,则跳过分析。
            $all_the_same1="F" if $japtmp1[$k] ne $ref1;
            $all_the_same2="F" if $japtmp2[$k] ne $ref2;
            $all_the_same3="F" if $japtmp3[$k] ne $ref3;

            $all_the_same1="F" if $barthtmp1[$k] ne $ref1;
            $all_the_same2="F" if $barthtmp2[$k] ne $ref2;
            $all_the_same3="F" if $barthtmp3[$k] ne $ref3;

            $all_the_same1="F" if $rufitmp1[$k] ne $ref1;
            $all_the_same2="F" if $rufitmp2[$k] ne $ref2;
            $all_the_same3="F" if $rufitmp3[$k] ne $ref3;
        }

        my @tmptmp1_jap=keys %jap_snp1;      ##根据hash,判断有几个值。
        my @tmptmp1_barth=keys %barth_snp1;
        my @tmptmp1_rufi=keys %rufi_snp1;

        my @tmptmp2_jap=keys %jap_snp2;
        my @tmptmp2_barth=keys %barth_snp2;
        my @tmptmp2_rufi=keys %rufi_snp2;

        my @tmptmp3_jap=keys %jap_snp3;
        my @tmptmp3_barth=keys %barth_snp3;
        my @tmptmp3_rufi=keys %rufi_snp3;

        if ($#tmptmp1_jap ==0 and $#tmptmp1_rufi ==0 and $#tmptmp1_barth==0){
            $final_snp1_flag[$n]="fix" if $final_sys_repl_none ne "none";
        }
        if ($#tmptmp2_jap ==0 and $#tmptmp2_rufi ==0 and $#tmptmp2_barth==0){
            $final_snp2_flag[$n]="fix" if $final_sys_repl_none ne "none";
        }

        if ($#tmptmp3_jap ==0 and $#tmptmp3_rufi ==0 and $#tmptmp3_barth==0){
            $final_snp3_flag[$n]="fix" if $final_sys_repl_none ne "none";
        }
	my $k;
        if ($all_the_same1 eq "F"){
            print "$n\t$final_sys_repl_none\t$final_snp1_flag[$n]\t$ref1\t";
	    if ($final_sys_repl_none eq "sys"){
		if($final_snp1_flag[$n] eq "fix"){
		    $sys_fix++;
		}elsif($final_snp1_flag[$n] eq "poly"){
		    $sys_poly++;
		}
	    }elsif($final_sys_repl_none eq "repl"){
		if($final_snp1_flag[$n] eq "fix"){
		    $repl_fix++;
		}elsif($final_snp1_flag[$n] eq "poly"){
		    $repl_poly++;
		}
	    }
            for ($k=1;$k<=$acc1;$k++){
                print "$japtmp1[$k]";
            }
            print "\t";
            for ($k=1;$k<=$acc2;$k++){
                print "$rufitmp1[$k]";
            }
            print "\t";
            for ($k=1;$k<=$acc3;$k++){
                print "$barthtmp1[$k]";
            }
            print "\n";
        }

        if ($all_the_same2 eq "F"){
            print "$n+1\t$final_sys_repl_none\t$final_snp2_flag[$n]\t$ref2\t";
	    if ($final_sys_repl_none eq "sys"){
		if($final_snp2_flag[$n] eq "fix"){
		    $sys_fix++;
		}elsif($final_snp2_flag[$n] eq "poly"){
		    $sys_poly++;
		}
	    }elsif($final_sys_repl_none eq "repl"){
		if($final_snp2_flag[$n] eq "fix"){
		    $repl_fix++;
		}elsif($final_snp2_flag[$n] eq "poly"){
		    $repl_poly++;
		}
	    }
            for ($k=1;$k<=$acc1;$k++){
                print "$japtmp2[$k]";
            }
            print "\t";
            for ($k=1;$k<=$acc2;$k++){
                print "$rufitmp2[$k]";
            }
            print "\t";
            for ($k=1;$k<=$acc3;$k++){
                print "$barthtmp2[$k]";
            }
            print "\n";
        }

        if ($all_the_same3 eq "F"){
            print "$n+2\t$final_sys_repl_none\t$final_snp3_flag[$n]\t$ref3\t";
	    if ($final_sys_repl_none eq "sys"){
		if($final_snp3_flag[$n] eq "fix"){
		    $sys_fix++;
		}elsif($final_snp3_flag[$n] eq "poly"){
		    $sys_poly++;
		}
	    }elsif($final_sys_repl_none eq "repl"){
		if($final_snp3_flag[$n] eq "fix"){
		    $repl_fix++;
		}elsif($final_snp3_flag[$n] eq "poly"){
		    $repl_poly++;
		}
	    }
            for ($k=1;$k<=$acc1;$k++){
                print "$japtmp3[$k]";
            }
            print "\t";
            for ($k=1;$k<=$acc2;$k++){
                print "$rufitmp3[$k]";
            }
            print "\t";
            for ($k=1;$k<=$acc3;$k++){
                print "$barthtmp3[$k]";
            }
            print "\n";
        }
    }
    print "\n===========================================================\n\t\tTable for 2x2 G-test:\n===========================================================\n\t\t Fixed\tPolymorphic\nReplacement\t  $repl_fix\t  $repl_poly\nSynonymous\t  $sys_fix\t  $sys_poly\n===========================================================\n";
#    if ($repl_fix==0 or $repl_poly==0 or $sys_fix==0 or $sys_poly==0){
#	print "The parameter is eq to 0, G-test is not avalable!\n\n";
 #   }else{
    my $gtest_stat_G=&sub_G($repl_fix,$repl_poly,$sys_fix,$sys_poly);
    my $gtest_stat_Y=&sub_G_Y($repl_fix,$repl_poly,$sys_fix,$sys_poly);
    my $gtest_stat_W=&sub_G_W($repl_fix,$repl_poly,$sys_fix,$sys_poly);
    
    my $a=Math::CDF::pchisq($gtest_stat_G,1);
    $a=1-$a;
    print "$input_file: Log likelihood ratio G-test of independence, $gtest_stat_G the p-value is: $a\n";
    $a=Math::CDF::pchisq($gtest_stat_W,1);
    $a=1-$a;
    print "$input_file: Log likelihood ratio G-test of independence with Williams' correction, the p-value is: $a\n";
    $a=Math::CDF::pchisq($gtest_stat_Y,1);
    $a=1-$a;
    print "$input_file: Log likelihood ratio G-test of independence with Yates' correction, the p-value is: $a\n";
  #  }

}

#my $gtest_stat_G=&sub_G_W(0,10,17,42);
#my $a=Math::CDF::pchisq($gtest_stat_G,1);
#$a=1-$a;
#print "Log likelihood ratio G-test of independence, $gtest_stat_G the p-value is: $a\n";




### sub start ##################################################################################

sub sub_G()
{
    my @line=@_;
    my $total=$line[1]+$line[2]+$line[3]+$line[0];
    my $volume_A=$line[0]+$line[2];
    my $volume_B=$line[1]+$line[3];
    my $volume_C=$line[1]+$line[0];
    my $volume_D=$line[2]+$line[3];
    my $expe_A1=$volume_A/$total*$volume_C;  ################################这一项可能为零
    my $expe_A3=$volume_A/$total*$volume_D;
    my $expe_A2=$volume_B/$total*$volume_C;
    my $expe_A4=$volume_B/$total*$volume_D;
    my $G;
#    $G=2*($line[0]*log($line[0]/$expe_A1)+$line[1]*log($line[1]/$expe_A2)+$line[2]*log($line[2]/$expe_A3)+$line[3]*log($line[3]/$expe_A4));
    if ($line[0]==0){
	if ($line[1]==0){ ## 2 为 0
	    if ($line[2]==0){ ## 3 为0
		if ($line[3]==0){
		    $G=0;
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4));
		}
	    }else{
		if ($line[3]==0){## 4 为0
		    $G=2*($line[2]*log($line[2]/$expe_A3));
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[2]*log($line[2]/$expe_A3));
		}
	    }
	}else{
	    if ($line[2]==0){
		if ($line[3]==0){
		    $G=2*($line[1]*log($line[1]/$expe_A2));;
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[1]*log($line[1]/$expe_A2));
		}
	    }else{
		if ($line[3]==0){
		    $G=2*($line[2]*log($line[2]/$expe_A3)+$line[1]*log($line[1]/$expe_A2));
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[2]*log($line[2]/$expe_A3)+$line[1]*log($line[1]/$expe_A2));
		}
	    }
	}
    }else{
	if ($line[1]==0){ ## 2 为 0
	    if ($line[2]==0){ ## 3 为0
		if ($line[3]==0){
		    $G=2*($line[0]*log($line[0]/$expe_A1));
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[0]*log($line[0]/$expe_A1));
		}
	    }else{
		if ($line[3]==0){## 4 为0
		    $G=2*($line[2]*log($line[2]/$expe_A3)+$line[0]*log($line[0]/$expe_A1));
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[2]*log($line[2]/$expe_A3)+$line[0]*log($line[0]/$expe_A1));
		}
	    }
	}else{
	    if ($line[2]==0){
		if ($line[3]==0){
		    $G=2*($line[1]*log($line[1]/$expe_A2)+$line[0]*log($line[0]/$expe_A1));;
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[1]*log($line[1]/$expe_A2)+$line[0]*log($line[0]/$expe_A1));
		}
	    }else{
		if ($line[3]==0){
		    $G=2*($line[2]*log($line[2]/$expe_A3)+$line[1]*log($line[1]/$expe_A2)+$line[0]*log($line[0]/$expe_A1));
		}else{
#		    print "		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[2]*log($line[2]/$expe_A3)+$line[1]*log($line[1]/$expe_A2)+$line[0]*log($line[0]/$expe_A1));
#\n";
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[2]*log($line[2]/$expe_A3)+$line[1]*log($line[1]/$expe_A2)+$line[0]*log($line[0]/$expe_A1));##############################这里存在分母为零的情况
		}
	    }
	}
    }
    return $G;
}

sub sub_G_Y()
{
    my @Yline=@_;
    my $yates_A1;
    my $yates_A2;
    my $yates_A3;
    my $yates_A4;
    if (($Yline[0]*$Yline[3]-$Yline[1]*$Yline[2])>0){
	$yates_A1=$Yline[0]-0.5;
	$yates_A4=$Yline[3]-0.5;
	$yates_A2=$Yline[1]+0.5;
	$yates_A3=$Yline[2]+0.5;
    }else{
	$yates_A1=$Yline[0]+0.5;
	$yates_A4=$Yline[3]+0.5;
	$yates_A2=$Yline[1]-0.5;
	$yates_A3=$Yline[2]-0.5;
    }
    my $Y=&sub_G($yates_A1,$yates_A2,$yates_A3,$yates_A4);
    return $Y;
}

sub sub_G_W()
{
    my @line=@_;
    my $total=$line[1]+$line[2]+$line[3]+$line[0];
    my $volume_A=$line[0]+$line[2];
    my $volume_B=$line[1]+$line[3];
    my $volume_C=$line[1]+$line[0];
    my $volume_D=$line[2]+$line[3];
    my $expe_A1=$volume_A/$total*$volume_C;
    my $expe_A3=$volume_A/$total*$volume_D;
    my $expe_A2=$volume_B/$total*$volume_C;
    my $expe_A4=$volume_B/$total*$volume_D;
    my $row_tot=1/$volume_C+1/$volume_D;
    my $col_tot=1/$volume_A+1/$volume_B;
    my $modi= 1+(($total*$row_tot-1)*($total*$col_tot-1))/(6*$total);
#    my $G=2*($line[0]*log($line[0]/$expe_A1)+$line[1]*log($line[1]/$expe_A2)+$line[2]*log($line[2]/$expe_A3)+$line[3]*log($line[3]/$expe_A4))/$modi;
    my $G;
    if ($line[0]==0){
	if ($line[1]==0){ ## 2 为 0
	    if ($line[2]==0){ ## 3 为0
		if ($line[3]==0){
		    $G=0;
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4));
		}
	    }else{
		if ($line[3]==0){## 4 为0
		    $G=2*($line[2]*log($line[2]/$expe_A3));
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[2]*log($line[2]/$expe_A3));
		}
	    }
	}else{
	    if ($line[2]==0){
		if ($line[3]==0){
		    $G=2*($line[1]*log($line[1]/$expe_A2));;
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[1]*log($line[1]/$expe_A2));
		}
	    }else{
		if ($line[3]==0){
		    $G=2*($line[2]*log($line[2]/$expe_A3)+$line[1]*log($line[1]/$expe_A2));
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[2]*log($line[2]/$expe_A3)+$line[1]*log($line[1]/$expe_A2));
		}
	    }
	}
    }else{
	if ($line[1]==0){ ## 2 为 0
	    if ($line[2]==0){ ## 3 为0
		if ($line[3]==0){
		    $G=2*($line[0]*log($line[0]/$expe_A1));
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[0]*log($line[0]/$expe_A1));
		}
	    }else{
		if ($line[3]==0){## 4 为0
		    $G=2*($line[2]*log($line[2]/$expe_A3)+$line[0]*log($line[0]/$expe_A1));
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[2]*log($line[2]/$expe_A3)+$line[0]*log($line[0]/$expe_A1));
		}
	    }
	}else{
	    if ($line[2]==0){
		if ($line[3]==0){
		    $G=2*($line[1]*log($line[1]/$expe_A2)+$line[0]*log($line[0]/$expe_A1));;
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[1]*log($line[1]/$expe_A2)+$line[0]*log($line[0]/$expe_A1));
		}
	    }else{
		if ($line[3]==0){
		    $G=2*($line[2]*log($line[2]/$expe_A3)+$line[1]*log($line[1]/$expe_A2)+$line[0]*log($line[0]/$expe_A1));
		}else{
		    $G=2*($line[3]*log($line[3]/$expe_A4)+$line[2]*log($line[2]/$expe_A3)+$line[1]*log($line[1]/$expe_A2)+$line[0]*log($line[0]/$expe_A1));
		}
	    }
	}
    }
    $G=$G/$modi;
    return $G;
}


sub expand_codon(){
    my ($expandtmp_codon,$expandtmp1,$expandtmp2,$expandtmp3)=@_;
    my %expandtmp_codon;
    if ($expandtmp1=~/M|W|Y|K|S|R|H|V|D|B/){
	if ($expandtmp2=~/M|W|Y|K|S|R|H|V|D|B/){
	    if ($expandtmp3=~/M|W|Y|K|S|R|H|V|D|B/){
		%expandtmp_codon=&expand_codon_all($expandtmp_codon,$expandtmp1,$expandtmp2,$expandtmp3);
	    }else{
		%expandtmp_codon=&expand_codon_first_and_second($expandtmp_codon,$expandtmp1,$expandtmp2,$expandtmp3);
	    }
	}else{
	    if ($expandtmp3=~/M|W|Y|K|S|R|H|V|D|B/){
		%expandtmp_codon=&expand_codon_first_and_third($expandtmp_codon,$expandtmp1,$expandtmp2,$expandtmp3);
	    }else{
		%expandtmp_codon=&expand_codon_first($expandtmp_codon,$expandtmp1,$expandtmp2,$expandtmp3);
	    }
	}
    }else{
	if ($expandtmp2=~/M|W|Y|K|S|R|H|V|D|B/){
	    if ($expandtmp3=~/M|W|Y|K|S|R|H|V|D|B/){
		%expandtmp_codon=&expand_codon_second_and_third($expandtmp_codon,$expandtmp1,$expandtmp2,$expandtmp3);
	    }else{
		%expandtmp_codon=&expand_codon_second($expandtmp_codon,$expandtmp1,$expandtmp2,$expandtmp3);
	    }
	}else{
	    if ($expandtmp3=~/M|W|Y|K|S|R|H|V|D|B/){
		%expandtmp_codon=&expand_codon_third($expandtmp_codon,$expandtmp1,$expandtmp2,$expandtmp3);
	    }
	}
    }
    return %expandtmp_codon;
}

sub expand_codon_all(){
    my ($expandtmp_codon,$expandtmp1,$expandtmp2,$expandtmp3)=@_;    
    my %expandtmp_codon1;
    my %expandtmp_codon2;
    my %expandtmp_codon3;

    if ($expandtmp1 eq "M"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"A",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"C",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
    }elsif($expandtmp1 eq "W"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"A",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"T",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
    }elsif($expandtmp1 eq "Y"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"C",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"T",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
    }elsif($expandtmp1 eq "K"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"G",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"T",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
    }elsif($expandtmp1 eq "S"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"G",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"C",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
    }elsif($expandtmp1 eq "R"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"G",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"A",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
    }elsif($expandtmp1 eq "H"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"C",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"A",$expandtmp2,$expandtmp3);
        %expandtmp_codon3=&expand_codon_second_and_third($expandtmp_codon,"T",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
        @expandtmp_codon1{keys %expandtmp_codon3} = values %expandtmp_codon3;
    }elsif($expandtmp1 eq "V"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"C",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"A",$expandtmp2,$expandtmp3);
        %expandtmp_codon3=&expand_codon_second_and_third($expandtmp_codon,"G",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
        @expandtmp_codon1{keys %expandtmp_codon3} = values %expandtmp_codon3;
    }elsif($expandtmp1 eq "D"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"T",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"A",$expandtmp2,$expandtmp3);
        %expandtmp_codon3=&expand_codon_second_and_third($expandtmp_codon,"G",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
        @expandtmp_codon1{keys %expandtmp_codon3} = values %expandtmp_codon3;
    }elsif($expandtmp1 eq "B"){
        %expandtmp_codon1=&expand_codon_second_and_third($expandtmp_codon,"T",$expandtmp2,$expandtmp3);
        %expandtmp_codon2=&expand_codon_second_and_third($expandtmp_codon,"C",$expandtmp2,$expandtmp3);
        %expandtmp_codon3=&expand_codon_second_and_third($expandtmp_codon,"G",$expandtmp2,$expandtmp3);
        @expandtmp_codon1{keys %expandtmp_codon2} = values %expandtmp_codon2;
        @expandtmp_codon1{keys %expandtmp_codon3} = values %expandtmp_codon3;
    }
    return %expandtmp_codon1;
}

sub expand_codon_first_and_second(){
    my ($expdtmp_codon,$expdtmp1,$expdtmp2,$expdtmp3)=@_;    
    my %expdtmp_codon1;
    my %expdtmp_codon2;
    my %expdtmp_codon3;

    if ($expdtmp1 eq "M"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"A",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"C",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
    }elsif($expdtmp1 eq "W"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"A",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"T",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
    }elsif($expdtmp1 eq "Y"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"C",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"T",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
    }elsif($expdtmp1 eq "K"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"G",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"T",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
    }elsif($expdtmp1 eq "S"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"G",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"C",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
    }elsif($expdtmp1 eq "R"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"G",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"A",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
    }elsif($expdtmp1 eq "H"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"C",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"A",$expdtmp2,$expdtmp3);
        %expdtmp_codon3=&expand_codon_second($expdtmp_codon,"T",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
        @expdtmp_codon1{keys %expdtmp_codon3} = values %expdtmp_codon3;
    }elsif($expdtmp1 eq "V"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"C",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"A",$expdtmp2,$expdtmp3);
        %expdtmp_codon3=&expand_codon_second($expdtmp_codon,"G",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
        @expdtmp_codon1{keys %expdtmp_codon3} = values %expdtmp_codon3;
    }elsif($expdtmp1 eq "D"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"T",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"A",$expdtmp2,$expdtmp3);
        %expdtmp_codon3=&expand_codon_second($expdtmp_codon,"G",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
        @expdtmp_codon1{keys %expdtmp_codon3} = values %expdtmp_codon3;
    }elsif($expdtmp1 eq "B"){
        %expdtmp_codon1=&expand_codon_second($expdtmp_codon,"T",$expdtmp2,$expdtmp3);
        %expdtmp_codon2=&expand_codon_second($expdtmp_codon,"C",$expdtmp2,$expdtmp3);
        %expdtmp_codon3=&expand_codon_second($expdtmp_codon,"G",$expdtmp2,$expdtmp3);
        @expdtmp_codon1{keys %expdtmp_codon2} = values %expdtmp_codon2;
        @expdtmp_codon1{keys %expdtmp_codon3} = values %expdtmp_codon3;
    }
    return %expdtmp_codon1;
}


sub expand_codon_first_and_third(){
    my ($eptmp_codon,$eptmp1,$eptmp2,$eptmp3)=@_;    
    my %eptmp_codon1;
    my %eptmp_codon2;
    my %eptmp_codon3;
    if ($eptmp1 eq "M"){
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"A",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"C",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
    }elsif($eptmp1 eq "W"){			      
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"A",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"T",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
    }elsif($eptmp1 eq "Y"){			      
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"C",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"T",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
    }elsif($eptmp1 eq "K"){			      
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"G",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"T",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
    }elsif($eptmp1 eq "S"){			      
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"G",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"C",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
    }elsif($eptmp1 eq "R"){			      
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"G",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"A",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
    }elsif($eptmp1 eq "H"){			      
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"C",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"A",$eptmp2,$eptmp3);
	%eptmp_codon3=&expand_codon_third($eptmp_codon,"T",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
	@eptmp_codon1{keys %eptmp_codon3} = values %eptmp_codon3;
    }elsif($eptmp1 eq "V"){			      
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"C",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"A",$eptmp2,$eptmp3);
	%eptmp_codon3=&expand_codon_third($eptmp_codon,"G",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
	@eptmp_codon1{keys %eptmp_codon3} = values %eptmp_codon3;
    }elsif($eptmp1 eq "D"){			      
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"T",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"A",$eptmp2,$eptmp3);
	%eptmp_codon3=&expand_codon_third($eptmp_codon,"G",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
	@eptmp_codon1{keys %eptmp_codon3} = values %eptmp_codon3;
    }elsif($eptmp1 eq "B"){			      
	%eptmp_codon1=&expand_codon_third($eptmp_codon,"T",$eptmp2,$eptmp3);
	%eptmp_codon2=&expand_codon_third($eptmp_codon,"C",$eptmp2,$eptmp3);
	%eptmp_codon3=&expand_codon_third($eptmp_codon,"G",$eptmp2,$eptmp3);
	@eptmp_codon1{keys %eptmp_codon2} = values %eptmp_codon2;
	@eptmp_codon1{keys %eptmp_codon3} = values %eptmp_codon3;
    }
    return %eptmp_codon1;
}


sub expand_codon_second_and_third(){
    my ($extmp_codon,$extmp1,$extmp2,$extmp3)=@_;    
    my %extmp_codon1;
    my %extmp_codon2;
    my %extmp_codon3;

    if ($extmp2 eq "M"){
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"A",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"C",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
    }elsif($extmp2 eq "W"){			      
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"A",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"T",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
    }elsif($extmp2 eq "Y"){			      
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"C",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"T",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
    }elsif($extmp2 eq "K"){			      
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"G",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"T",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
    }elsif($extmp2 eq "S"){			      
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"G",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"C",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
    }elsif($extmp2 eq "R"){			      
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"G",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"A",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
    }elsif($extmp2 eq "H"){			      
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"C",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"A",$extmp3);
	%extmp_codon3=&expand_codon_third($extmp_codon,$extmp1,"T",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
	@extmp_codon1{keys %extmp_codon3} = values %extmp_codon3;
    }elsif($extmp2 eq "V"){			      
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"C",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"A",$extmp3);
	%extmp_codon3=&expand_codon_third($extmp_codon,$extmp1,"G",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
	@extmp_codon1{keys %extmp_codon3} = values %extmp_codon3;
    }elsif($extmp2 eq "D"){			      
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"T",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"A",$extmp3);
	%extmp_codon3=&expand_codon_third($extmp_codon,$extmp1,"G",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
	@extmp_codon1{keys %extmp_codon3} = values %extmp_codon3;
    }elsif($extmp2 eq "B"){			      
	%extmp_codon1=&expand_codon_third($extmp_codon,$extmp1,"T",$extmp3);
	%extmp_codon2=&expand_codon_third($extmp_codon,$extmp1,"C",$extmp3);
	%extmp_codon3=&expand_codon_third($extmp_codon,$extmp1,"G",$extmp3);
	@extmp_codon1{keys %extmp_codon2} = values %extmp_codon2;
	@extmp_codon1{keys %extmp_codon3} = values %extmp_codon3;
    }
    return %extmp_codon1;
}


sub expand_codon_first(){
    my ($extmp_codon,$extmp1,$extmp2,$extmp3)=@_;    
    my %extmp_codon;
    if ($extmp1 eq "M"){
        $extmp_codon{$extmp_codon}{"1"}="A".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="C".$extmp2.$extmp3;
    }elsif($extmp1 eq "W"){
        $extmp_codon{$extmp_codon}{"1"}="A".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="T".$extmp2.$extmp3;
    }elsif($extmp1 eq "Y"){
        $extmp_codon{$extmp_codon}{"1"}="C".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="T".$extmp2.$extmp3;
    }elsif($extmp1 eq "K"){
        $extmp_codon{$extmp_codon}{"1"}="G".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="T".$extmp2.$extmp3;
    }elsif($extmp1 eq "S"){
        $extmp_codon{$extmp_codon}{"1"}="C".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="G".$extmp2.$extmp3;
    }elsif($extmp1 eq "R"){
        $extmp_codon{$extmp_codon}{"1"}="A".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="G".$extmp2.$extmp3;
    }elsif($extmp1 eq "H"){
        $extmp_codon{$extmp_codon}{"1"}="A".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="C".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"3"}="T".$extmp2.$extmp3;
    }elsif($extmp1 eq "V"){
        $extmp_codon{$extmp_codon}{"1"}="A".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="C".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"3"}="G".$extmp2.$extmp3;
    }elsif($extmp1 eq "D"){
        $extmp_codon{$extmp_codon}{"1"}="A".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="G".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"3"}="T".$extmp2.$extmp3;
    }elsif($extmp1 eq "B"){
        $extmp_codon{$extmp_codon}{"1"}="G".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"2"}="C".$extmp2.$extmp3;
        $extmp_codon{$extmp_codon}{"3"}="T".$extmp2.$extmp3;
    }
    return %extmp_codon;
}


sub expand_codon_second(){
    my ($extmp_codon,$extmp1,$extmp2,$extmp3)=@_;    
    my %extmp_codon;
    if ($extmp2 eq "M"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."A".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."C".$extmp3;
    }elsif($extmp2 eq "W"){			      
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."A".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."T".$extmp3;
    }elsif($extmp2 eq "Y"){			      
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."C".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."T".$extmp3;
    }elsif($extmp2 eq "K"){			      
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."G".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."T".$extmp3;
    }elsif($extmp2 eq "S"){			      
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."C".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."G".$extmp3;
    }elsif($extmp2 eq "R"){			      
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."A".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."G".$extmp3;
    }elsif($extmp2 eq "H"){			      
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."A".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."C".$extmp3;
        $extmp_codon{$extmp_codon}{"3"}=$extmp1."T".$extmp3;
    }elsif($extmp2 eq "V"){			      
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."A".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."C".$extmp3;
        $extmp_codon{$extmp_codon}{"3"}=$extmp1."G".$extmp3;
    }elsif($extmp2 eq "D"){			      
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."A".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."G".$extmp3;
        $extmp_codon{$extmp_codon}{"3"}=$extmp1."T".$extmp3;
    }elsif($extmp2 eq "B"){			      
        $extmp_codon{$extmp_codon}{"1"}=$extmp1."G".$extmp3;
        $extmp_codon{$extmp_codon}{"2"}=$extmp1."C".$extmp3;
        $extmp_codon{$extmp_codon}{"3"}=$extmp1."T".$extmp3;
    }
    return %extmp_codon;
}


sub expand_codon_third(){
    my ($extmp_codon,$extmp1,$extmp2,$extmp3)=@_;    
    my %extmp_codon;
    if ($extmp3 eq "M"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."A";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."C";
    }elsif($extmp3 eq "W"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."A";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."T";
    }elsif($extmp3 eq "Y"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."C";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."T";
    }elsif($extmp3 eq "K"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."G";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."T";
    }elsif($extmp3 eq "S"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."C";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."G";
    }elsif($extmp3 eq "R"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."A";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."G";
    }elsif($extmp3 eq "H"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."A";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."C";
        $extmp_codon{$extmp_codon}{"3"}=$extmp1.$extmp2."T";
    }elsif($extmp3 eq "V"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."A";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."C";
        $extmp_codon{$extmp_codon}{"3"}=$extmp1.$extmp2."G";
    }elsif($extmp3 eq "D"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."A";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."G";
        $extmp_codon{$extmp_codon}{"3"}=$extmp1.$extmp2."T";
    }elsif($extmp3 eq "B"){
        $extmp_codon{$extmp_codon}{"1"}=$extmp1.$extmp2."G";
        $extmp_codon{$extmp_codon}{"2"}=$extmp1.$extmp2."C";
        $extmp_codon{$extmp_codon}{"3"}=$extmp1.$extmp2."T";
    }
    return %extmp_codon;
}

sub given_snp(){
    my ($snp,@my_snp_line)=@_;
    my @snp=split/\:/,$snp;
    my $final_snp;
    my @tmp_snp;
    my @array;


    
    if ($my_snp_line[8]=~/INDEL/ or $my_snp_line[7]=~/INDEL/){
	$final_snp="I";# if length($my_snp_line[3])>1;	
    }else{
	if ($snp[0] eq "0/0"){
	    $final_snp=$my_snp_line[3];
	}elsif($snp[0] eq "./."){
	    $final_snp="N";	    
	}else{
	    if ($my_snp_line[4]=~/\,/){
		@tmp_snp=split/\,/,$my_snp_line[4];
		if ($snp[0] eq "1/1"){
		    $final_snp=$tmp_snp[0];
		}elsif($snp[0] eq "0/1"){
		    @array=("$my_snp_line[3]","$tmp_snp[0]");
		    $final_snp=&DNA_oligo(@array);
		}elsif($snp[0] eq "0/2"){
		    @array=("$my_snp_line[3]","$tmp_snp[1]");
		    $final_snp=&DNA_oligo(@array);
		}elsif($snp[0] eq "1/2"){
		    @array=("$tmp_snp[0]","$tmp_snp[1]");
		    $final_snp=&DNA_oligo(@array);
		}elsif($snp[0] eq "2/2"){
		    $final_snp=$tmp_snp[1];
		}else{
		    print "type is not belong to GT, something is wrong here!\n";
		    exit;
		}
	    }else{
		if ($snp[0] eq "1/1"){
		    $final_snp=$my_snp_line[4];
		}else{
		    @array=("$my_snp_line[3]","$my_snp_line[4]");
		    $final_snp=&DNA_oligo(@array);
		}
	    }
	}
    }
    return $final_snp;
}


sub DNA_oligo(){
    my @dna=@_;
    my $dna;
    my $tmpdna;
    @dna=sort (@dna);
    $dna=join("",@dna);

    if ($dna eq "AC"){
        $tmpdna="M";
    }
    if ($dna eq "CT"){
        $tmpdna="Y";
    }
    if ($dna eq "GT"){
        $tmpdna="K";
    }
    if ($dna eq "CG"){
        $tmpdna="S";
    }
    if ($dna eq "AG"){
        $tmpdna="R";
    }
    if ($dna eq "AT"){
        $tmpdna="W";
    }

    if ($dna eq "ACT"){
        $tmpdna="H";
    }
    if ($dna eq "ACG"){
        $tmpdna="V";
    }
    if ($dna eq "AGT"){
        $tmpdna="D";
    }
    if ($dna eq "CGT"){
        $tmpdna="B";
    }
#    if ($dna eq "ACGT"){
#        $tmpdna="N";
#    }

    return $tmpdna;
}


sub oligo_DNA(){
    my ($dna)=@_;
    my @dna;
    if ($dna eq "M"){
	@dna=("A","C");
    }
    if ($dna eq "W"){
	@dna=("A","T");
    }
    if ($dna eq "Y"){
	@dna=("T","C");
    }
    if ($dna eq "K"){
	@dna=("G","T");
    }
    if ($dna eq "S"){
	@dna=("G","C");
    }
    if ($dna eq "R"){
	@dna=("A","G");
    }
    if ($dna eq "H"){
	@dna=("A","T","C");
    }
    if ($dna eq "V"){
	@dna=("A","G","C");
    }
    if ($dna eq "D"){
	@dna=("A","T","G");
    }
    if ($dna eq "B"){
	@dna=("G","T","C");
    }
#    if ($dna eq "N"){
#	@dna=("A","G","T","C");
#    }

    return @dna;
}


sub codon_table
{
    my %codon;
    $codon{"TTT"}="F";
    $codon{"TTC"}="F";
    $codon{"TTA"}="L";
    $codon{"TTG"}="L";
    $codon{"CTA"}="L";
    $codon{"CTG"}="L";
    $codon{"CTT"}="L";
    $codon{"CTC"}="L";
    $codon{"ATA"}="I";
    $codon{"ATC"}="I";
    $codon{"ATT"}="I";
    $codon{"ATG"}="M";
    $codon{"GTA"}="V";
    $codon{"GTC"}="V";
    $codon{"GTT"}="V";
    $codon{"GTG"}="V";
    $codon{"TCA"}="S";
    $codon{"TCT"}="S";
    $codon{"TCG"}="S";
    $codon{"TCC"}="S";
    $codon{"CCT"}="P";
    $codon{"CCA"}="P";
    $codon{"CCC"}="P";
    $codon{"CCG"}="P";
    $codon{"ACA"}="T";
    $codon{"ACT"}="T";
    $codon{"ACG"}="T";
    $codon{"ACC"}="T";
    $codon{"GCT"}="A";
    $codon{"GCA"}="A";
    $codon{"GCC"}="A";
    $codon{"GCG"}="A";
    $codon{"TAT"}="Y";
    $codon{"TAC"}="Y";
    $codon{"TAA"}="*";
    $codon{"TAG"}="*";
    $codon{"CAT"}="H";
    $codon{"CAC"}="H";
    $codon{"CAA"}="Q";
    $codon{"CAG"}="Q";
    $codon{"AAT"}="N";
    $codon{"AAC"}="N";
    $codon{"AAG"}="K";
    $codon{"AAA"}="K";
    $codon{"GAT"}="D";
    $codon{"GAC"}="D";
    $codon{"GAG"}="E";
    $codon{"GAA"}="E";
    $codon{"TGG"}="W";
    $codon{"TGA"}="*";
    $codon{"TGC"}="C";
    $codon{"TGT"}="C";
    $codon{"CGT"}="R";
    $codon{"CGC"}="R";
    $codon{"CGG"}="R";
    $codon{"CGA"}="R";
    $codon{"AGA"}="R";
    $codon{"AGG"}="R";
    $codon{"AGT"}="S";
    $codon{"AGC"}="S";
    $codon{"GGG"}="G";
    $codon{"GGC"}="G";
    $codon{"GGA"}="G";
    $codon{"GGT"}="G";
    return %codon;
}

sub read_fasta_file_new()
{
#必须输入2个参数，分别为文件名，以及ID分隔符
    my %hash;
    my ($file_name,$sep)=@_;
    my $aa;
    my $id;
    my @lines;
    open (PEP,"$file_name") or die "wrong";
    my $first_id=<PEP>;
    chomp $first_id;
    $first_id=~s/>//;
    if ($sep eq "dot"){
	@lines=split/\./,$first_id;
    }elsif($sep eq "shu"){
	@lines=split/\|/,$first_id;
    }elsif($sep eq "space"){
	@lines=split/\s/,$first_id;
    }elsif($sep eq "join"){
	@lines=split/\s+|\t/,$first_id;
	my $tmp=join("-",@lines);
	$lines[0]=$tmp;
    }else{
	@lines=($first_id);
	#$lines[0]=$first_id;
    }
    
    $id=$lines[0];
#    print "****$id***\n";
    while (<PEP>){
	chomp;
	if ($_=~s/>//){
	    $aa=~s/\*//;
	    $hash{$id}=$aa;
	    $aa="";    
##################不同的文件格式，对这一部分需要微调#############################
	    if ($sep eq "dot"){
		@lines=split/\./,$_;
	    }elsif($sep eq "shu"){
		@lines=split/\|/,$_;
	    }elsif($sep eq "space"){
		@lines=split/\s/,$_;
	    }elsif($sep eq "join"){
		@lines=split/\s+|\t/,$_;
		my $tmp=join("-",@lines);
		$lines[0]=$tmp;
	    }else{
		@lines=($_);
	    }
	    $id=$lines[0];
###############################################
	}else{
	    $aa.=$_;
	}
    }

    $aa=~s/\*//;
#    print "**$id***$aa***\n";
    $hash{$id}=$aa;
    return %hash;
}
